<?php
include('db_connect.php');

// Check if the request method is GET or POST
if ($_SERVER['REQUEST_METHOD'] === 'GET' || $_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get the last_index from the request data (GET or POST depending on the method)
    $last_index = isset($_REQUEST['last_index']) ? intval($_REQUEST['last_index']) : 0;

    // Use the last_index in the SQL query
    $sql = "SELECT *
        FROM `posts`
        WHERE `id` > $last_index
        ORDER BY `id`
        LIMIT 40;
    ";

    $result = mysqli_query($conn, $sql);

    // Create an array to hold the results
    $response = array();

    // Loop through the result set and add each row to the response array
    while ($row = mysqli_fetch_assoc($result)) {
        $response[] = $row;
    }

    // Return the response as JSON
    echo json_encode($response);
} else {
    // If the request method is neither GET nor POST, return an error or handle it accordingly
    echo json_encode(array('error' => 'Invalid request method'));
}
?>
