<?php
include('db_connect.php');

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Check if content, author, and category are sent in the request
    if (
        isset($_POST['content']) && isset($_POST['author']) &&
        isset($_POST['category'])
    ) {
        // Get content, author, and category from the request
        $content = mysqli_real_escape_string($conn, $_POST['content']);
        $author = mysqli_real_escape_string($conn, $_POST['author']);
        $category = mysqli_real_escape_string($conn, $_POST['category']);

        // Check if images are sent in the request
        if (isset($_FILES['images']) && is_array($_FILES['images']['name'])) {
            // Specify the directory to save the uploaded images
            $uploadDirectory = 'uploads/';

            $imagePaths = array();

            // Loop through each uploaded image
            for ($i = 0; $i < count($_FILES['images']['name']); $i++) {
                // Generate a unique filename to avoid overwriting existing files
                $uploadedFileName = uniqid() . '_' . basename($_FILES['images']['name'][$i]);
                $targetFilePath = $uploadDirectory . $uploadedFileName;

                // Move the uploaded file to the specified directory
                if (move_uploaded_file($_FILES['images']['tmp_name'][$i], $targetFilePath)) {
                    // Image uploaded successfully
                    $safeFilePath = mysqli_real_escape_string($conn, $targetFilePath);
                    $imagePaths[] = $safeFilePath;
                } else {
                    // Error moving the uploaded file
                    echo json_encode(array('error' => 'Error uploading images to the server'));
                    exit;
                }
            }

            // Convert array of image paths to a comma-separated string
            $imagesString = implode(',', $imagePaths);
        } else {
            // No images received, set $imagesString to 'None'
            $imagesString = 'None';
        }

        // Get the current timestamp as a formatted string (YYYY-MM-DD HH:MM:SS)
        $currentTimestamp = date('Y-m-d H:i:s');
        
        // Insert data into the posts table with the current timestamp
        $sql = "INSERT INTO `posts` (`content`, `author`, `image`, `category`, `approved`, `timestamp`)
                VALUES ('$content', '$author', '$imagesString', '$category', 0, '$currentTimestamp')";



        if (mysqli_query($conn, $sql)) {
            // Insert successful
            echo json_encode(array('success' => 'Data inserted successfully'));
        } else {
            // Insert failed
            echo json_encode(array('error' => 'Error adding data to the database', 'sql_error' => mysqli_error($conn)));
        }
    } else {
        // Missing data
        echo json_encode(array('error' => 'Missing data'));
    }
} else {
    // If the request method is not POST, return an error or handle it accordingly
    echo json_encode(array('error' => 'Invalid request method'));
}
?>
